/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.block.entity;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriSoil;
import com.agricraft.agricraft.api.config.CoreConfig;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.crop.AgriGrowthStage;
import com.agricraft.agricraft.api.fertilizer.AgriFertilizer;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.plant.AgriWeed;
import com.agricraft.agricraft.api.requirement.AgriGrowthConditionRegistry;
import com.agricraft.agricraft.api.requirement.AgriGrowthResponse;
import com.agricraft.agricraft.api.stat.AgriStat;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import com.agricraft.agricraft.api.tools.magnifying.MagnifyingInspectable;
import com.agricraft.agricraft.common.block.CropBlock;
import com.agricraft.agricraft.common.block.CropState;
import com.agricraft.agricraft.common.block.SimpleFluidloggedBlock;
import com.agricraft.agricraft.common.registry.ModBlockEntityTypes;
import com.agricraft.agricraft.common.util.LangUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CropBlockEntity
extends class_2586
implements AgriCrop,
MagnifyingInspectable {
    private final Map<Integer, class_265> shapeByAge = new HashMap<Integer, class_265>();
    private AgriGenome genome;
    private String plantId = "";
    private AgriPlant plant;
    private AgriGrowthStage growthStage = null;
    private String weedId = "";
    private AgriWeed weed;
    private AgriGrowthStage weedGrowthStage = null;

    public CropBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlockEntityTypes.CROP.get(), blockPos, blockState);
    }

    public void method_11014(class_2487 tag) {
        boolean hasWeeds;
        super.method_11014(tag);
        boolean hasPlant = tag.method_10577("hasPlant");
        if (hasPlant) {
            this.genome = AgriGenome.fromNBT(tag);
            this.plantId = this.genome == null ? "agricraft:unknown" : this.genome.getSpeciesGene().getDominant().trait();
            int growthIndex = tag.method_10550("growthIndex");
            int growthTotal = tag.method_10550("growthTotal");
            this.growthStage = new AgriGrowthStage(growthIndex, growthTotal);
            if (this.plant == null && this.field_11863 != null) {
                this.plant = AgriApi.getPlant(this.plantId, this.field_11863.method_30349()).orElse(null);
            }
        }
        if (hasWeeds = tag.method_10577("hasWeeds")) {
            this.weedId = tag.method_10558("weedId");
            int weedGrowthIndex = tag.method_10550("weedGrowthIndex");
            int weedGrowthTotal = tag.method_10550("weedGrowthTotal");
            this.weedGrowthStage = new AgriGrowthStage(weedGrowthIndex, weedGrowthTotal);
            if (this.weed == null && this.field_11863 != null) {
                this.weed = AgriApi.getWeed(this.weedId, this.field_11863.method_30349()).orElse(null);
            }
        }
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.hasPlant()) {
            tag.method_10556("hasPlant", true);
            this.genome.writeToNBT(tag);
            tag.method_10569("growthIndex", this.growthStage.index());
            tag.method_10569("growthTotal", this.growthStage.total());
        } else {
            tag.method_10556("hasPlant", false);
        }
        if (this.hasWeeds()) {
            tag.method_10556("hasWeeds", true);
            tag.method_10582("weedId", this.weedId);
            tag.method_10569("weedGrowthIndex", this.weedGrowthStage.index());
            tag.method_10569("weedGrowthTotal", this.weedGrowthStage.total());
        } else {
            tag.method_10556("hasWeeds", false);
        }
    }

    @NotNull
    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        if (level != null && !level.field_9236) {
            this.plant = AgriApi.getPlant(this.plantId, level.method_30349()).orElse(null);
            if (this.plant != null && this.growthStage == null) {
                this.growthStage = this.plant.getInitialGrowthStage();
            }
            this.weed = AgriApi.getWeed(this.weedId, level.method_30349()).orElse(null);
            if (this.weed != null && this.growthStage == null) {
                this.growthStage = this.weed.getInitialGrowthStage();
            }
            level.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    @Override
    public boolean removeGenome() {
        if (this.hasPlant()) {
            if (this.method_11010().method_11654(CropBlock.CROP_STATE) == CropState.PLANT_STICKS) {
                this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657(CropBlock.CROP_STATE, (Comparable)((Object)CropState.SINGLE_STICKS)));
            } else if (((Boolean)this.method_11010().method_11654((class_2769)SimpleFluidloggedBlock.LAVALOGGED)).booleanValue()) {
                this.field_11863.method_8501(this.method_11016(), class_3612.field_15908.method_15785().method_15759());
            } else if (((Boolean)this.method_11010().method_11654((class_2769)SimpleFluidloggedBlock.WATERLOGGED)).booleanValue()) {
                this.field_11863.method_8501(this.method_11016(), class_3612.field_15910.method_15785().method_15759());
            } else {
                this.field_11863.method_8501(this.method_11016(), class_2246.field_10124.method_9564());
            }
            this.getPlant().onRemoved(this);
            this.genome = null;
            this.plant = null;
            this.plantId = "";
            this.growthStage = null;
            return true;
        }
        return false;
    }

    @Override
    public AgriGenome getGenome() {
        return this.genome;
    }

    @Override
    public void plantGenome(AgriGenome genome, @Nullable class_1309 entity) {
        if (genome == null) {
            return;
        }
        this.genome = genome;
        this.plantId = genome.getSpeciesGene().getDominant().trait();
        this.plant = AgriApi.getPlant(this.plantId, this.field_11863.method_30349()).orElse(null);
        if (this.plant != null) {
            this.growthStage = this.plant.getInitialGrowthStage();
        }
        this.field_11863.method_8652(this.method_11016(), this.hasCropSticks() ? (class_2680)((class_2680)this.method_11010().method_11657(CropBlock.CROP_STATE, (Comparable)((Object)CropState.PLANT_STICKS))).method_11657((class_2769)CropBlock.LIGHT, (Comparable)Integer.valueOf(this.plant.getBrightness(this))) : (class_2680)this.method_11010().method_11657((class_2769)CropBlock.LIGHT, (Comparable)Integer.valueOf(this.plant.getBrightness(this))), 3);
        this.plant.onPlanted(this, null);
    }

    @Override
    public boolean hasPlant() {
        return ((CropState)((Object)this.method_11010().method_11654(CropBlock.CROP_STATE))).hasPlant() && !this.plantId.isEmpty() && this.plant != null;
    }

    @Override
    public boolean hasWeeds() {
        return !this.weedId.isEmpty() && this.weed != null;
    }

    @Override
    public boolean hasCropSticks() {
        return ((CropState)((Object)this.method_11010().method_11654(CropBlock.CROP_STATE))).hasSticks();
    }

    @Override
    public boolean isCrossCropSticks() {
        return this.method_11010().method_11654(CropBlock.CROP_STATE) == CropState.DOUBLE_STICKS;
    }

    @Override
    public String getPlantId() {
        return this.plantId;
    }

    @Override
    public AgriPlant getPlant() {
        return this.plant;
    }

    @Override
    public AgriGrowthStage getGrowthStage() {
        return this.growthStage;
    }

    @Override
    public String getWeedId() {
        return this.weedId;
    }

    @Override
    public AgriWeed getWeed() {
        return this.weed;
    }

    @Override
    public AgriGrowthStage getWeedGrowthStage() {
        return this.weedGrowthStage;
    }

    @Override
    public void setGrowthStage(AgriGrowthStage stage) {
        this.growthStage = stage;
        this.method_5431();
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), (class_2680)this.method_11010().method_11657((class_2769)CropBlock.LIGHT, (Comparable)Integer.valueOf(this.plant.getBrightness(this))), 3);
    }

    @Override
    public void setWeedGrowthStage(AgriGrowthStage stage) {
        this.weedGrowthStage = stage;
        this.method_5431();
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.hasPlant() ? (class_2680)this.method_11010().method_11657((class_2769)CropBlock.LIGHT, (Comparable)Integer.valueOf(this.plant.getBrightness(this))) : this.method_11010(), 3);
    }

    @Override
    public void removeWeeds() {
        if (this.hasWeeds()) {
            this.weed = null;
            this.weedId = "";
            this.weedGrowthStage = null;
            this.method_5431();
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.hasPlant() ? (class_2680)this.method_11010().method_11657((class_2769)CropBlock.LIGHT, (Comparable)Integer.valueOf(this.plant.getBrightness(this))) : this.method_11010(), 3);
        }
    }

    @Override
    public AgriGrowthResponse getFertilityResponse() {
        if (!this.checkGrowthSpace(this.plant.getPlantHeight(this.growthStage))) {
            return AgriGrowthResponse.INFERTILE;
        }
        if (AgriGrowthConditionRegistry.getInstance().isEmpty()) {
            return AgriGrowthResponse.FERTILE;
        }
        int strength = this.genome.getStatGene(AgriStatRegistry.getInstance().strengthStat()).getTrait();
        Optional<AgriGrowthResponse> optional = AgriGrowthConditionRegistry.getInstance().stream().map(condition -> condition.check(this, this.field_11863, this.method_11016(), strength)).reduce((result, element) -> result.priority() >= element.priority() ? result : element);
        return optional.orElse(AgriGrowthResponse.FERTILE);
    }

    @Override
    public Optional<AgriSoil> getSoil() {
        return AgriApi.getSoil((class_1922)this.field_11863, this.method_11016().method_10074(), this.field_11863.method_30349());
    }

    public class_265 getShape() {
        double yoffset = 0.0;
        if (this.field_11863.method_8320(this.method_11016().method_10074()).method_27852(class_2246.field_10362)) {
            yoffset = -0.0625;
        }
        if (!this.hasPlant()) {
            if (this.hasWeeds()) {
                return this.shapeByAge.computeIfAbsent(this.weedGrowthStage.index(), stage -> class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)this.weed.getWeedHeight(this.weedGrowthStage), (double)16.0)).method_1096(0.0, yoffset, 0.0);
            }
            return class_259.method_1073();
        }
        return this.shapeByAge.computeIfAbsent(this.growthStage.index(), stage -> class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)this.plant.getPlantHeight(this.growthStage), (double)16.0)).method_1096(0.0, yoffset, 0.0);
    }

    @Override
    public void getHarvestProducts(Consumer<class_1799> addToHarvest) {
        if (!this.hasPlant() || !this.isFullyGrown()) {
            return;
        }
        for (int trials = (this.genome.getGain() + 3) / 3; trials > 0; --trials) {
            this.plant.getHarvestProducts(addToHarvest, this.growthStage, this.genome, this.field_11863.field_9229);
        }
    }

    @Override
    public void getClippingProducts(Consumer<class_1799> addToClipping, class_1799 clipper) {
        if (!this.hasPlant() || !this.isFullyGrown()) {
            return;
        }
        this.plant.getClipProducts(addToClipping, clipper, this.growthStage, this.genome, this.field_11863.field_9229);
    }

    @Override
    public boolean acceptsFertilizer(AgriFertilizer fertilizer) {
        if (this.isCrossCropSticks()) {
            return CoreConfig.allowFertilizerMutation && fertilizer.canTriggerMutation();
        }
        if (this.hasPlant()) {
            return !this.isFullyGrown() && fertilizer.canFertilize(this);
        }
        return fertilizer.canTriggerWeeds();
    }

    @Override
    public void applyGrowthTick() {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        if (this.shouldWeedsActivate()) {
            this.executeWeedsGrowthTick();
        } else if (this.method_11010().method_11654(CropBlock.CROP_STATE) == CropState.DOUBLE_STICKS) {
            AgriApi.getMutationHandler().getActiveCrossBreedEngine().handleCrossBreedTick(this, this.streamNeighbours(), this.field_11863.field_9229);
        } else {
            if (!this.hasPlant()) {
                return;
            }
            AgriGrowthResponse fertility = this.getFertilityResponse();
            if (fertility.isInstantKill()) {
                fertility.onPlantKilled(this);
                this.removeGenome();
            } else if (fertility.isLethal()) {
                this.revertGrowthStage();
            } else if (fertility.isFertile()) {
                this.executePlantGrowthTick();
            }
        }
    }

    protected void executeWeedsGrowthTick() {
        if (!this.hasWeeds()) {
            AgriApi.getWeedRegistry().flatMap(registry -> registry.method_29722().stream().filter(entry -> this.field_11863.method_8409().method_43058() < ((AgriWeed)entry.getValue()).getSpawnChance(this)).findAny()).ifPresent(entry -> this.setWeed(((class_5321)entry.getKey()).method_29177().toString(), (AgriWeed)entry.getValue()));
        } else if (this.weedGrowthStage.isFinal()) {
            this.tryWeedKillPlant();
            this.spreadWeeds();
        } else {
            double f = this.getSoil().map(AgriSoil::growthModifier).orElse(1.0);
            if (this.field_11863.method_8409().method_43058() < f * this.weed.getGrowthChance(this.weedGrowthStage)) {
                this.weedGrowthStage = this.weedGrowthStage.getNext(this, this.field_11863.method_8409());
                this.method_5431();
                this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.hasPlant() ? (class_2680)this.method_11010().method_11657((class_2769)CropBlock.LIGHT, (Comparable)Integer.valueOf(this.plant.getBrightness(this))) : this.method_11010(), 3);
            }
        }
    }

    @Override
    public void setWeed(String weedId, AgriWeed weed) {
        if (this.checkGrowthSpace(weed.getWeedHeight(weed.getInitialGrowthStage()))) {
            this.weedId = weedId;
            this.weed = weed;
            this.weedGrowthStage = weed.getInitialGrowthStage();
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.hasPlant() ? (class_2680)this.method_11010().method_11657((class_2769)CropBlock.LIGHT, (Comparable)Integer.valueOf(this.plant.getBrightness(this))) : this.method_11010(), 3);
        }
    }

    protected void tryWeedKillPlant() {
        if (CoreConfig.matureWeedsKillPlants && this.weed.isLethal() && this.hasPlant() && this.shouldWeedsActivate()) {
            this.revertGrowthStage();
        }
    }

    protected void spreadWeeds() {
        if (CoreConfig.weedsSpreading && this.weed.isAggressive()) {
            this.streamNeighbours().filter(crop -> !crop.hasWeeds()).filter(AgriCrop::shouldWeedsActivate).forEach(crop -> crop.setWeed(this.weedId, this.weed));
        }
    }

    public boolean checkGrowthSpace(int height) {
        if (this.field_11863 == null) {
            return false;
        }
        while (height > 16) {
            int offset = height / 16;
            class_2338 up = this.method_11016().method_10086(offset);
            if (!this.field_11863.method_8320(up).method_26215()) {
                return false;
            }
            height -= 16;
        }
        return true;
    }

    public Stream<AgriCrop> streamNeighbours() {
        return class_2350.class_2353.field_11062.method_29716().map(dir -> this.method_11016().method_10093(dir)).map(pos -> AgriApi.getCrop((class_1922)this.field_11863, pos)).filter(Optional::isPresent).map(Optional::get);
    }

    protected void revertGrowthStage() {
        AgriGrowthStage current = this.growthStage;
        AgriGrowthStage prev = this.growthStage.getPrevious(this, this.field_11863.field_9229);
        if (current.equals(prev)) {
            this.removeGenome();
        } else {
            this.setGrowthStage(prev);
        }
    }

    protected void executePlantGrowthTick() {
        double b;
        if (this.isFullyGrown()) {
            return;
        }
        double a = this.calculateGrowthRate();
        if (a > (b = this.field_11863.field_9229.method_43058())) {
            this.setGrowthStage(this.growthStage.getNext(this, this.field_11863.field_9229));
            this.getPlant().onGrowth(this);
        }
    }

    protected double calculateGrowthRate() {
        int growth = this.genome.getStatGene(AgriStatRegistry.getInstance().growthStat()).getTrait();
        double soilFactor = this.getSoil().map(AgriSoil::growthModifier).orElse(1.0);
        return soilFactor * (this.plant.getGrowthChance(this.growthStage) + (double)growth * this.plant.getBonusGrowthChance(this.growthStage) * CoreConfig.growthMultiplier);
    }

    @Override
    public void addMagnifyingTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (this.hasPlant()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.crop"));
            tooltip.add((class_2561)class_2561.method_43470((String)"  ").method_27662().method_10852((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.species")).method_10852(LangUtils.plantName(this.genome.getSpeciesGene().getDominant().trait())).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27662()).method_10852(LangUtils.plantName(this.genome.getSpeciesGene().getRecessive().trait())));
            AgriStatRegistry.getInstance().stream().filter(stat -> !stat.isHidden()).map(stat -> this.genome.getStatGene((AgriStat)stat)).sorted(Comparator.comparing(p -> p.getGene().getId())).map(genePair -> class_2561.method_43469((String)("agricraft.tooltip.magnifying.stat." + genePair.getGene().getId()), (Object[])new Object[]{genePair.getDominant().trait(), genePair.getRecessive().trait()})).map(component -> class_2561.method_43470((String)"  ").method_10852((class_2561)component)).forEach(tooltip::add);
            if (isPlayerSneaking) {
                tooltip.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43469((String)"agricraft.tooltip.magnifying.growth", (Object[])new Object[]{this.growthStage.index() + 1, this.growthStage.total()})));
            }
            if (this.field_11863.field_9236) {
                this.field_11863.method_8533();
            }
            AgriGrowthResponse response = this.getFertilityResponse();
            tooltip.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43471((String)("agricraft.tooltip.magnifying.requirement." + (response.isLethal() ? "lethal" : (response.isFertile() ? "fertile" : "not_fertile"))))));
            if (!response.isFertile()) {
                if (!this.checkGrowthSpace(this.plant.getPlantHeight(this.growthStage))) {
                    tooltip.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43471((String)"agricraft.tooltip.condition.growth_space")));
                }
                int strength = this.genome.getStrength();
                AgriGrowthConditionRegistry.getInstance().stream().filter(condition -> !condition.check(this, this.field_11863, this.method_11016(), strength).isFertile()).forEach(condition -> condition.notMetDescription(component -> tooltip.add((class_2561)class_2561.method_43470((String)"  ").method_10852(component))));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.no_plant"));
        }
        if (this.hasWeeds()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.weeds").method_10852(LangUtils.weedName(this.weedId)));
            if (isPlayerSneaking) {
                tooltip.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43469((String)"agricraft.tooltip.magnifying.growth", (Object[])new Object[]{this.weedGrowthStage.index() + 1, this.weedGrowthStage.total()})));
            }
        }
    }

    @Override
    public class_2338 method_11016() {
        return super.method_11016();
    }

    @Override
    public class_2680 method_11010() {
        return super.method_11010();
    }

    @Override
    @Nullable
    public class_1937 method_10997() {
        return super.method_10997();
    }
}

